/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.mixin.accessors.HeroGiftsTaskAccess;
import blusunrize.immersiveengineering.mixin.accessors.SingleJigsawAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Villages {
    public static final ResourceLocation ENGINEER = ImmersiveEngineering.rl("engineer");
    public static final ResourceLocation MACHINIST = ImmersiveEngineering.rl("machinist");
    public static final ResourceLocation ELECTRICIAN = ImmersiveEngineering.rl("electrician");
    public static final ResourceLocation OUTFITTER = ImmersiveEngineering.rl("outfitter");
    public static final ResourceLocation GUNSMITH = ImmersiveEngineering.rl("gunsmith");

    public static void init() {
        PlainVillagePools.m_127185_();
        SnowyVillagePools.m_127233_();
        SavannaVillagePools.m_127230_();
        DesertVillagePools.m_126860_();
        TaigaVillagePools.m_127305_();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            for (String type : new String[]{"engineer", "machinist", "electrician", "gunsmith", "outfitter"}) {
                Villages.addToPool(new ResourceLocation("village/" + biome + "/houses"), ImmersiveEngineering.rl("village/houses/" + biome + "_" + type), 1);
            }
        }
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ENGINEER.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/engineer"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_MACHINIST.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/machinist"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ELECTRICIAN.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/electrician"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_OUTFITTER.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/outfitter"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_GUNSMITH.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/gunsmith"));
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        StructureTemplatePool old = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        int id = BuiltinRegistries.f_123864_.m_7447_((Object)old);
        List shuffled = old != null ? old.m_210588_(new Random(0L)) : ImmutableList.of();
        Object2IntLinkedOpenHashMap newPieces = new Object2IntLinkedOpenHashMap();
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext()) {
            StructurePoolElement p = (StructurePoolElement)iterator.next();
            newPieces.computeInt((Object)p, (pTemp, i) -> (i == null ? 0 : i) + 1);
        }
        newPieces.put((Object)SingleJigsawAccess.construct((Either<ResourceLocation, StructureTemplate>)Either.left((Object)toAdd), (Holder<StructureProcessorList>)ProcessorLists.f_127198_, StructureTemplatePool.Projection.RIGID), weight);
        List newPieceList = newPieces.object2IntEntrySet().stream().map(e -> Pair.of((Object)((StructurePoolElement)e.getKey()), (Object)e.getIntValue())).collect(Collectors.toList());
        ResourceLocation name = old.m_210587_();
        ((WritableRegistry)BuiltinRegistries.f_123864_).m_203384_(OptionalInt.of(id), ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123864_.m_123023_(), (ResourceLocation)name), (Object)new StructureTemplatePool(pool, name, newPieceList), Lifecycle.stable());
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PoiType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"immersiveengineering");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"immersiveengineering");
        public static final RegistryObject<PoiType> POI_CRAFTINGTABLE = POINTS_OF_INTEREST.register("craftingtable", () -> Registers.createPOI("craftingtable", Registers.assembleStates(IEBlocks.WoodenDevices.CRAFTING_TABLE.get())));
        public static final RegistryObject<PoiType> POI_ANVIL = POINTS_OF_INTEREST.register("anvil", () -> Registers.createPOI("anvil", Registers.assembleStates(Blocks.f_50322_)));
        public static final RegistryObject<PoiType> POI_CIRCUITTABLE = POINTS_OF_INTEREST.register("energymeter", () -> Registers.createPOI("energymeter", Registers.assembleStates(IEBlocks.WoodenDevices.CIRCUIT_TABLE.get())));
        public static final RegistryObject<PoiType> POI_BANNER = POINTS_OF_INTEREST.register("shaderbanner", () -> Registers.createPOI("shaderbanner", Registers.assembleStates(IEBlocks.Cloth.SHADER_BANNER.get())));
        public static final RegistryObject<PoiType> POI_WORKBENCH = POINTS_OF_INTEREST.register("workbench", () -> Registers.createPOI("workbench", Registers.assembleStates(IEBlocks.WoodenDevices.WORKBENCH.get())));
        public static final RegistryObject<VillagerProfession> PROF_ENGINEER = PROFESSIONS.register(ENGINEER.m_135815_(), () -> Registers.createProf(ENGINEER, (PoiType)POI_CRAFTINGTABLE.get(), SoundEvents.f_12572_));
        public static final RegistryObject<VillagerProfession> PROF_MACHINIST = PROFESSIONS.register(MACHINIST.m_135815_(), () -> Registers.createProf(MACHINIST, (PoiType)POI_ANVIL.get(), SoundEvents.f_12574_));
        public static final RegistryObject<VillagerProfession> PROF_ELECTRICIAN = PROFESSIONS.register(ELECTRICIAN.m_135815_(), () -> Registers.createProf(ELECTRICIAN, (PoiType)POI_CIRCUITTABLE.get(), IESounds.spark));
        public static final RegistryObject<VillagerProfession> PROF_OUTFITTER = PROFESSIONS.register(OUTFITTER.m_135815_(), () -> Registers.createProf(OUTFITTER, (PoiType)POI_BANNER.get(), SoundEvents.f_12565_));
        public static final RegistryObject<VillagerProfession> PROF_GUNSMITH = PROFESSIONS.register(GUNSMITH.m_135815_(), () -> Registers.createProf(GUNSMITH, (PoiType)POI_WORKBENCH.get(), IESounds.revolverReload));

        private static PoiType createPOI(String name, Collection<BlockState> block) {
            return new PoiType("immersiveengineering:" + name, (Set)ImmutableSet.copyOf(block), 1, 1);
        }

        private static VillagerProfession createProf(ResourceLocation name, PoiType poi, SoundEvent sound) {
            return new VillagerProfession(name.toString(), poi, ImmutableSet.builder().build(), ImmutableSet.builder().build(), sound);
        }

        private static Collection<BlockState> assembleStates(Block block) {
            return block.m_49965_().m_61056_().stream().filter(blockState -> {
                if (blockState.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE)) {
                    return (Boolean)blockState.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE) == false;
                }
                return true;
            }).collect(Collectors.toList());
        }
    }

    private static class PriceInterval {
        private final int min;
        private final int max;

        private PriceInterval(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getPrice(Random rand) {
            return this.min >= this.max ? this.min : this.min + rand.nextInt(this.max - this.min + 1);
        }
    }

    private static class RevolverPieceForEmeralds
    implements VillagerTrades.ItemListing {
        public MerchantOffer m_5670_(Entity trader, @Nonnull Random random) {
            int part = random.nextInt(3);
            ItemStack stack = new ItemStack(part == 0 ? IEItems.Ingredients.GUNPART_BARREL : (part == 1 ? IEItems.Ingredients.GUNPART_DRUM : IEItems.Ingredients.GUNPART_HAMMER));
            float luck = 1.0f;
            if (trader instanceof AbstractVillager && ((AbstractVillager)trader).m_35306_()) {
                luck = ((AbstractVillager)trader).m_7962_().m_36336_();
            }
            CompoundTag perksTag = RevolverItem.RevolverPerk.generatePerkSet(random, luck);
            ItemNBTHelper.setTagCompound(stack, "perks", perksTag);
            int tier = Math.max(1, RevolverItem.RevolverPerk.calculateTier(perksTag));
            ItemNBTHelper.putBoolean(stack, "generatePerks", true);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5 * tier + random.nextInt(5)), stack, 1, 30, 0.25f);
        }
    }

    private static class OreveinMapForEmeralds
    implements VillagerTrades.ItemListing {
        public PriceInterval value;
        private static final int SEARCH_RADIUS = 512;

        @Nullable
        public MerchantOffer m_5670_(Entity trader, @Nonnull Random random) {
            Level world = trader.m_20193_();
            BlockPos merchantPos = trader.m_142538_();
            ArrayList<MineralVein> veins = new ArrayList<MineralVein>();
            for (int i = 0; i < 8; ++i) {
                int offZ;
                int offX = random.nextInt(1024) - 512;
                MineralVein vein = ExcavatorHandler.getRandomMineral(world, merchantPos.m_142082_(offX, 0, offZ = random.nextInt(1024) - 512));
                if (vein == null || vein.getMineral(world) == null || veins.contains(vein)) continue;
                veins.add(vein);
            }
            if (veins.size() > 0) {
                veins.sort(Comparator.comparingInt(o -> o.getMineral((Level)world).weight));
                MineralVein vein = (MineralVein)veins.get(0);
                BlockPos blockPos = new BlockPos(vein.getPos().f_140723_, 64, vein.getPos().f_140724_);
                ItemStack selling = MapItem.m_42886_((Level)world, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)1, (boolean)true, (boolean)true);
                MapItem.m_42897_((Level)world, (ItemStack)selling);
                MapItemSavedData.m_77925_((ItemStack)selling, (BlockPos)blockPos, (String)"ie:coresample_treasure", (MapDecoration.Type)MapDecoration.Type.RED_X);
                selling.m_41714_((Component)new TranslatableComponent("item.immersiveengineering.map_orevein"));
                ItemNBTHelper.setLore(selling, new Component[]{new TranslatableComponent(vein.getMineral(world).getTranslationKey())});
                ItemStack steelIngot = IEApi.getPreferredTagStack(trader.f_19853_.m_5962_(), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot);
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 8 + random.nextInt(8)), ItemHandlerHelper.copyStackWithSize((ItemStack)steelIngot, (int)(4 + random.nextInt(8))), selling, 0, 1, 30, 0.5f);
            }
            return null;
        }
    }

    private static class ItemsForEmerald
    implements VillagerTrades.ItemListing {
        public ItemStack sellingItem;
        public PriceInterval priceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public ItemsForEmerald(ItemLike par1Item, PriceInterval priceInfo, int maxUses, int xp) {
            this(new ItemStack(par1Item), priceInfo, maxUses, xp);
        }

        public ItemsForEmerald(ItemStack par1Item, PriceInterval priceInfo, int maxUses, int xp) {
            this(par1Item, priceInfo, maxUses, xp, 0.05f);
        }

        public ItemsForEmerald(ItemLike par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this(new ItemStack(par1Item), priceInfo, maxUses, xp, priceMult);
        }

        public ItemsForEmerald(ItemStack par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this.sellingItem = par1Item;
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack selling;
            ItemStack buying;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(rand);
            }
            if (i < 0) {
                buying = new ItemStack((ItemLike)Items.f_42616_);
                selling = ItemHandlerHelper.copyStackWithSize((ItemStack)this.sellingItem, (int)(-i));
            } else {
                buying = new ItemStack((ItemLike)Items.f_42616_, i);
                selling = this.sellingItem;
            }
            return new MerchantOffer(buying, selling, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class EmeraldForItems
    implements VillagerTrades.ItemListing {
        private final Function<Level, ItemStack> getBuyingItem;
        @Nullable
        private ItemStack buyingItem;
        private final PriceInterval buyAmounts;
        private final int maxUses;
        private final int xp;

        public EmeraldForItems(@Nonnull Function<Level, ItemStack> item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this.getBuyingItem = item;
            this.buyAmounts = buyAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public EmeraldForItems(@Nonnull ItemLike item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this((Level l) -> new ItemStack(item), buyAmounts, maxUses, xp);
        }

        public EmeraldForItems(@Nonnull TagKey<Item> tag, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this((Level l) -> IEApi.getPreferredTagStack(l.m_5962_(), tag), buyAmounts, maxUses, xp);
        }

        public EmeraldForItems(@Nonnull ResourceLocation tag, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)tag), buyAmounts, maxUses, xp);
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            if (this.buyingItem == null) {
                this.buyingItem = Objects.requireNonNull(this.getBuyingItem.apply(trader.f_19853_));
            }
            return new MerchantOffer(ItemHandlerHelper.copyStackWithSize((ItemStack)this.buyingItem, (int)this.buyAmounts.getPrice(rand)), new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.xp, 0.05f);
        }
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent ev) {
            Int2ObjectMap trades = ev.getTrades();
            if (ENGINEER.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems(IETags.treatedStick, new PriceInterval(8, 16), 16, 1));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEBlocks.WoodenDecoration.TREATED_WOOD.get((Object)TreatedWoodStyles.HORIZONTAL), new PriceInterval(-10, -6), 12, 1));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEBlocks.Cloth.BALLOON, new PriceInterval(-3, -1), 12, 2));
                ((List)trades.get(2)).add(new EmeraldForItems(IETags.ironRod, new PriceInterval(2, 6), 12, 10));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(-4, -2), 12, 5));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(-4, -2), 12, 5));
                ((List)trades.get(3)).add(new EmeraldForItems(IETags.steelRod, new PriceInterval(2, 6), 12, 6));
                ((List)trades.get(3)).add(new EmeraldForItems(IEBlocks.StoneDecoration.CONCRETE, new PriceInterval(4, 8), 8, 12));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEBlocks.WoodenDevices.TREATED_WALLMOUNT, new PriceInterval(-3, -2), 10, 8));
                ((List)trades.get(4)).add(new ItemsForEmerald(IEBlocks.WoodenDecoration.TREATED_POST, new PriceInterval(-3, -2), 4, 10));
                ((List)trades.get(4)).add(new EmeraldForItems(IEBlocks.MetalDecoration.STEEL_POST, new PriceInterval(1, 2), 4, 20));
                ((List)trades.get(4)).add(new EmeraldForItems(IEBlocks.MetalDecoration.ALU_POST, new PriceInterval(1, 3), 6, 15));
                ((List)trades.get(4)).add(new EmeraldForItems(IEBlocks.StoneDecoration.CONCRETE_LEADED, new PriceInterval(2, 4), 10, 10));
                ((List)trades.get(5)).add(new OreveinMapForEmeralds());
            } else if (MACHINIST.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems(IETags.coalCoke, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEItems.Tools.HAMMER, new PriceInterval(4, 7), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new EmeraldForItems(IETags.getIngot(EnumMetals.COPPER.tagName()), new PriceInterval(4, 6), 6, 10));
                ((List)trades.get(2)).add(new EmeraldForItems(IETags.getIngot(EnumMetals.ALUMINUM.tagName()), new PriceInterval(4, 6), 6, 10));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEItems.Ingredients.COMPONENT_STEEL, new PriceInterval(1, 3), 12, 5));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEItems.Tools.TOOLBOX, new PriceInterval(6, 8), 3, 20, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEItems.Ingredients.WATERWHEEL_SEGMENT, new PriceInterval(1, 3), 8, 10));
                ((List)trades.get(2)).add(new EmeraldForItems(IETags.getPlate(EnumMetals.STEEL.tagName()), new PriceInterval(4, 6), 12, 7));
                ((List)trades.get(4)).add(new ItemsForEmerald(IEItems.Tools.DRILLHEAD_IRON, new PriceInterval(28, 40), 3, 15, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald(IEItems.Misc.EARMUFFS, new PriceInterval(4, 9), 3, 20, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald(IEItems.Tools.DRILLHEAD_STEEL, new PriceInterval(32, 48), 3, 30, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("electrode"), new PriceInterval(12, 24), 3, 30, 0.2f));
            } else if (ELECTRICIAN.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems(IETags.copperWire, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEItems.Tools.WIRECUTTER, new PriceInterval(4, 7), 12, 1, 0.2f));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEItems.Misc.WIRE_COILS.get(WireType.COPPER), new PriceInterval(-4, -2), 12, 1, 0.2f));
                ((List)trades.get(2)).add(new EmeraldForItems(IETags.electrumWire, new PriceInterval(6, 12), 12, 4));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEItems.Tools.VOLTMETER, new PriceInterval(4, 7), 3, 12, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM), new PriceInterval(-4, -1), 12, 5));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.FEET), new PriceInterval(5, 7), 3, 15, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.LEGS), new PriceInterval(9, 11), 3, 15, 0.2f));
                ((List)trades.get(3)).add(new EmeraldForItems(IETags.aluminumWire, new PriceInterval(4, 8), 20, 10));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEItems.Misc.WIRE_COILS.get(WireType.STEEL), new PriceInterval(-2, -1), 12, 8));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.CHEST), new PriceInterval(11, 15), 3, 18, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald(IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.HEAD), new PriceInterval(5, 7), 3, 18, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald(IEItems.Misc.FLUORESCENT_TUBE, new PriceInterval(8, 12), 3, 25, 0.2f));
                ((List)trades.get(4)).add(new ItemsForEmerald(IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_ELECTRO), new PriceInterval(8, 12), 3, 15, 0.2f));
                ((List)trades.get(5)).add(new ItemsForEmerald(IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_CAPACITORS), new PriceInterval(8, 12), 3, 30, 0.2f));
            } else if (OUTFITTER.equals((Object)ev.getType().getRegistryName())) {
                ItemLike bag_common = IEItems.Misc.SHADER_BAG.get(Rarity.COMMON);
                ItemLike bag_uncommon = IEItems.Misc.SHADER_BAG.get(Rarity.UNCOMMON);
                ItemLike bag_rare = IEItems.Misc.SHADER_BAG.get(Rarity.RARE);
                ((List)trades.get(1)).add(new ItemsForEmerald(bag_common, new PriceInterval(2, 8), 24, 1, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(bag_uncommon, new PriceInterval(8, 14), 24, 5, 0.2f));
                ((List)trades.get(3)).add(new ItemsForEmerald(bag_rare, new PriceInterval(14, 20), 24, 10, 0.2f));
            } else if (GUNSMITH.equals((Object)ev.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems(IEItems.Ingredients.EMPTY_CASING, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new EmeraldForItems(IEItems.Ingredients.EMPTY_SHELL, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald(IEItems.Ingredients.WOODEN_GRIP, new PriceInterval(2, 4), 1, 12, 0.2f));
                ((List)trades.get(2)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("bullet"), new PriceInterval(3, 6), 1, 25));
                ((List)trades.get(2)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.CASULL), new PriceInterval(-4, -2), 12, 5));
                ((List)trades.get(2)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.BUCKSHOT), new PriceInterval(-6, -2), 12, 5));
                ((List)trades.get(2)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.FLARE), new PriceInterval(-2, -1), 12, 10));
                ((List)trades.get(3)).add(new ItemsForEmerald(BlueprintCraftingRecipe.getTypedBlueprint("specialBullet"), new PriceInterval(5, 9), 1, 30, 0.2f));
                ((List)trades.get(4)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(4)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.SILVER), new PriceInterval(-4, -1), 8, 15));
                ((List)trades.get(4)).add(new ItemsForEmerald(BulletHandler.getBulletStack(BulletItem.HIGH_EXPLOSIVE), new PriceInterval(2, 4), 8, 15));
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
            }
        }
    }
}

